package pushsubscription

import (
	"strings"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/passport/infra/daemons/push_subscription/internal/errs"
	"a.yandex-team.ru/passport/infra/daemons/push_subscription/internal/model"
)

const (
	authorizationKeyForErr = "authorization"
	authorizationType      = "OAuth"
	authorizationHeader    = "Ya-Consumer-Authorization"
)

func checkAuthorization(ctx echo.Context, provider model.OAuthProvider) (*model.AuthResponse, error) {
	authHeader, err := getRequiredHeader(ctx.Request().Header, authorizationHeader, authorizationKeyForErr)
	if err != nil {
		return nil, err
	}
	token, err := getTokenFromAuthHeader(authHeader)
	if err != nil {
		return nil, &errs.InvalidParamError{
			Key:     authorizationKeyForErr,
			Type:    errs.InvalidParamErrorTypeInvalid,
			Message: err.Error(),
		}
	}

	return provider.CheckOAuth(ctx.Request().Context(), &model.AuthRequest{
		Token:  token,
		UserIP: ContextClientIP(ctx.Request().Context()).String(),
	})
}

func getTokenFromAuthHeader(header string) (string, error) {
	headerParts := strings.Split(header, " ")
	expectedLength := 2
	if len(headerParts) != expectedLength {
		return "", xerrors.Errorf("header has incorrect parts count: expected=%d, actual=%d",
			expectedLength, len(headerParts),
		)
	}

	if !strings.EqualFold(headerParts[0], authorizationType) {
		return "", xerrors.Errorf("got unsupported auth type: '%s'", headerParts[0])
	}

	return headerParts[1], nil
}
