package pushsubscription

import (
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/passport/shared/golibs/juggler"
)

func (t *PushSubscription) HandleHealthCheck() echo.HandlerFunc {
	return func(ctx echo.Context) error {
		status := juggler.NewStatusOk()
		status.Update(juggler.TvmClientStatus(t.tvm))
		return ctx.String(http.StatusOK, status.String())
	}
}
