package pushsubscription

import (
	"bytes"
	"net/url"
	"time"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/passport/shared/golibs/httpdaemon/middlewares"
)

func handleAccessLogMiddleware(accessLog log.Logger) echo.MiddlewareFunc {
	keysToProtect := map[string]interface{}{
		"device_token": nil,
	}

	protect := func(buffer *bytes.Buffer, v string) {
		buffer.WriteString(v[0 : len(v)/2])
		buffer.WriteString("...")
	}

	protectQuery := func(values url.Values) string {
		var buffer bytes.Buffer

		for k, v := range values {
			if buffer.Len() > 0 {
				buffer.WriteString("&")
			}

			buffer.WriteString(k)
			buffer.WriteString("=")

			if len(v) == 0 {
				continue
			}

			if _, ok := keysToProtect[k]; ok {
				protect(&buffer, v[0])
			} else {
				buffer.WriteString(v[0])
			}
		}

		return buffer.String()
	}

	optional := func(v string) string {
		if v == "" {
			return "-"
		}
		return v
	}

	return func(next echo.HandlerFunc) echo.HandlerFunc {
		return func(ctx echo.Context) (err error) {
			err = next(ctx)

			startTime := middlewares.ContextStartInstant(ctx.Request().Context())

			var token string
			if value, _ := getTokenFromAuthHeader(ctx.Request().Header.Get(authorizationHeader)); value != "" {
				var buffer bytes.Buffer
				protect(&buffer, value)
				token = buffer.String()
			}

			accessLog.Debugf(
				"%s\t%s\t%s\t%d\t%.2fms\t%s\t%s\t%s\t%s\t%s",
				middlewares.ContextReqID(ctx.Request().Context()),
				ctx.RealIP(),
				ContextClientIP(ctx.Request().Context()).String(),
				ctx.Response().Status,
				float64(time.Since(startTime).Microseconds())/1000,
				ctx.Request().Method,
				ctx.Request().URL.Path,
				optional(token),
				optional(protectQuery(ctx.Request().URL.Query())),
				optional(protectQuery(ctx.Request().PostForm)),
			)

			return err
		}
	}
}
