package pushsubscription

import (
	"context"
	"fmt"
	"net"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/passport/infra/daemons/push_subscription/internal/errs"
)

const (
	clientIPKeyForErr = "ip"
	clientIPHeader    = "Ya-Consumer-Client-Ip"
)

type ctxClientIPKey struct{}

var keyClientIP ctxClientIPKey

func WithClientIP(ctx context.Context, ip net.IP) context.Context {
	return context.WithValue(ctx, &keyClientIP, ip)
}

func ContextClientIP(ctx context.Context) (res net.IP) {
	res, _ = ctx.Value(&keyClientIP).(net.IP)
	return
}

func (t *PushSubscription) handleClientIP() echo.MiddlewareFunc {
	return func(next echo.HandlerFunc) echo.HandlerFunc {
		return func(ctx echo.Context) error {
			ipStr, err := getRequiredHeader(ctx.Request().Header, clientIPHeader, clientIPKeyForErr)
			if err != nil {
				return err
			}

			ip := net.ParseIP(ipStr)
			if ip == nil {
				return &errs.InvalidParamError{
					Key:     clientIPKeyForErr,
					Type:    errs.InvalidParamErrorTypeInvalid,
					Message: fmt.Sprintf("invalid client ip: '%s'", clientIPHeader),
				}
			}

			ctx.SetRequest(ctx.Request().WithContext(
				WithClientIP(ctx.Request().Context(), ip),
			))

			return next(ctx)
		}
	}
}
