package pushsubscription

import (
	"fmt"
	"net/http"
	"os"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/library/go/yandex/tvm"
	"a.yandex-team.ru/passport/shared/golibs/logger"
)

func (t *PushSubscription) HandlePing() echo.HandlerFunc {
	return func(c echo.Context) error {
		status, err := t.tvm.GetStatus(c.Request().Context())
		if err != nil {
			logger.Log().Errorf("Ping: Failed to get status from TVM client: %s", err)
			return c.String(http.StatusInternalServerError, "Failed to get status from TVM client")
		}
		if status.Status == tvm.ClientError {
			logger.Log().Errorf("Ping: bad TVM client status: %s", status.LastError)
			return c.String(http.StatusInternalServerError, fmt.Sprintf("TVM: %s", status.LastError))
		}

		if _, err := os.Stat(t.cfg.Common.ForceDownFile); err == nil {
			logger.Log().Debugf("Ping: Service is forced down")
			return c.String(http.StatusServiceUnavailable, "Service is forced down")
		}

		logger.Log().Debugf("Ping: service is up")
		return c.String(http.StatusOK, "Pong")
	}
}
