package pushsubscription

import (
	"fmt"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"a.yandex-team.ru/passport/infra/daemons/push_subscription/internal/errs"
)

func getRequiredStringParam(values url.Values, key string) (string, error) {
	res := values.Get(key)
	if res == "" {
		return "", &errs.InvalidParamError{
			Key:     key,
			Type:    errs.InvalidParamErrorTypeEmpty,
			Message: fmt.Sprintf("missing param: '%s'", key),
		}
	}

	return res, nil
}

func getRequiredUIntParam(values url.Values, key string) (uint64, error) {
	value := values.Get(key)
	if value == "" {
		return 0, &errs.InvalidParamError{
			Key:     key,
			Type:    errs.InvalidParamErrorTypeEmpty,
			Message: fmt.Sprintf("invalid param: '%s' must be unsigned int, got '%s'", key, value),
		}
	}

	valueInt, err := strconv.ParseUint(value, 10, 64)
	if err != nil {
		return 0, &errs.InvalidParamError{
			Key:     key,
			Type:    errs.InvalidParamErrorTypeInvalid,
			Message: fmt.Sprintf("invalid param: '%s' must be unsigned int, got '%s'", key, value),
		}
	}

	return valueInt, nil
}

func getOptionalBoolParam(values url.Values, key string) (*bool, error) {
	value := values.Get(key)
	if value == "" {
		return nil, nil
	}

	var res bool
	if strings.EqualFold(value, "false") {
		res = false
	} else if strings.EqualFold(value, "true") {
		res = true
	} else {
		return nil, &errs.InvalidParamError{
			Key:     key,
			Type:    errs.InvalidParamErrorTypeInvalid,
			Message: fmt.Sprintf("invalid param: '%s' must be boolean, got '%s'", key, value),
		}
	}

	return &res, nil
}

func getDefaultBoolParam(values url.Values, key string, def bool) (bool, error) {
	value, err := getOptionalBoolParam(values, key)
	if err != nil {
		return false, err
	}

	if value == nil {
		return def, nil
	}

	return *value, nil
}

func getRequiredHeader(headers http.Header, key, keyForErr string) (string, error) {
	value := headers.Get(key)
	if value == "" {
		return "", &errs.InvalidParamError{
			Key:     keyForErr,
			Type:    errs.InvalidParamErrorTypeEmpty,
			Message: fmt.Sprintf("missing header: '%s'", key),
		}
	}

	return value, nil
}
