package pushsubscription

import (
	"fmt"
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/passport/infra/daemons/push_subscription/internal/model"
	"a.yandex-team.ru/passport/infra/daemons/push_subscription/internal/reqs"
)

func (t *PushSubscription) HandleUnsubscribe() echo.HandlerFunc {
	return func(ctx echo.Context) error {
		req, err := parseUnsubscribeRequest(ctx)
		if err != nil {
			return err
		}

		uuid := createUUID(req.DeviceID, req.AppID)
		err = t.subscriber.Unsubscribe(ctx.Request().Context(), &model.UnsubscribeRequest{
			UUID: uuid,
			User: fmt.Sprintf("%d", req.UID),
		})
		if err != nil {
			return err
		}

		tskvPassportLine := t.newTskvPasspLineWithDefaultFields(ctx)
		tskvPassportLine.
			AddValue("action", "unsubscribed", false).
			AddValue("uid", fmt.Sprintf("%d", req.UID), false).
			AddValue("uuid", uuid, false)
		tskvPassportLine.Write()

		return ctx.JSON(http.StatusOK, responseStatusOk())
	}
}

func parseUnsubscribeRequest(ctx echo.Context) (*reqs.UnsubscribeRequest, error) {
	err := ctx.Request().ParseForm()
	if err != nil {
		return nil, err
	}

	query := ctx.Request().Form

	appID, err := getRequiredStringParam(query, "app_id")
	if err != nil {
		return nil, err
	}
	deviceid, err := getRequiredStringParam(query, "deviceid")
	if err != nil {
		return nil, err
	}
	uid, err := getRequiredUIntParam(query, "uid")
	if err != nil {
		return nil, err
	}

	return &reqs.UnsubscribeRequest{
		AppID:    appID,
		DeviceID: deviceid,
		UID:      uid,
	}, nil
}
