#!/bin/bash

# This script dumps some data from test db to use it as standalone test database
set -o errexit

# config files (databases) to dump:
readonly central_file='central.sql'
readonly shard1_file='shard1.sql'
readonly shard2_file='shard2.sql'
readonly oauthcentral_file='oauth_central.sql'
readonly oauthshard_file='oauth_shard.sql'
readonly oauthshard2_file='oauth_shard2.sql'

# dump options
readonly mysql_creds=("-h" "cnt-dbm-test.passport.yandex.net" "-P" "3306" "-u" "$BB_PASSPORTDB_USER_RW" "-p$BB_PASSPORTDB_PASSWD_RW")
readonly dump_params=("--skip-set-charset" "--add-locks" "--set-gtid-purged=OFF" "--skip-comments" "--single-transaction" "--disable-keys" "--no-tablespaces") # "--skip-extended-insert")


# selected data to dump
readonly shard_tables=("extended_attributes" \
 "email_bindings" "phone_bindings" "phone_bindings_history" "phone_operations"\
 "account_deletion_operations" "password_history" "tracks")
readonly oauth_central_tables=("client_attributes" "client_by_owner" "client_by_params" "client_by_uid")
readonly oauth_shard_tables=("token_attributes" "token_by_access_token" "token_by_alias")

readonly test_uids="(uid in (4001096104))"
readonly test_domains="domain_id in (1,4)"

readonly test_oauth_clients="id in (2267)"
readonly test_oauth_tokens="id in (0)"

readonly only_data_params=("--no-create-db" "--no-create-info" "--skip-triggers")
readonly binary_attributes="(100,101,102,180)"

readonly keyspaces_cond='domainsuff in (
  "yandex_by",
  "yandex_com_tr",
  "yandex_com",
  "yandex_kz",
  "yandex_ru",
  "yandex_ua",

  "beru_ru",
  "edadeal_ru",

  "cookiel",

  "signsmth",
  "signsmth_long",

  "guard_passport",
  "guard_oauth",
  "guard_test_1",
  "guard_test_2",
  "guard_test_dryrun",

  "oauth"
)'

dump_heading() {
    local db_name="$1"

    echo -e "\n-- CAUTION: This file is generated by make_dump.sh script."
    echo -e "-- Do not edit this file, or else all your changes will be discarded!\n\n"
    echo -e "CREATE DATABASE \`${db_name}\`;\nUSE \`${db_name}\`;\n\n"
}

dump_central() {
    local condition="$1"
    shift
    local tables=("$@")

    mysqldump "${mysql_creds[@]}" "${dump_params[@]}" --where="${condition:-true}" passportdbcentral "${tables[@]}" >> ${central_file}

    echo -e "\n\n" >> ${central_file}
}

dump_passportdbshard() {
  local db="$1"
  local filename="$2"
  dump_heading "${db}" > "${filename}"
  {
    mysqldump "${mysql_creds[@]}" "${dump_params[@]}" --where="${test_uids}" "${db}" "${shard_tables[@]}"
    mysqldump "${mysql_creds[@]}" "${dump_params[@]}" --where="${test_uids} and type not in ${binary_attributes}" "${db}" "attributes"
    mysqldump "${mysql_creds[@]}" "${dump_params[@]}" "${only_data_params[@]}" --hex-blob --where="${test_uids} and type in ${binary_attributes}" "${db}" "attributes"
    mysqldump "${mysql_creds[@]}" "${dump_params[@]}" --hex-blob --where="${test_uids}" "${db}" "passman_recovery_keys"
  } >> "${filename}"
}

# dump central

dump_heading "passportdbcentral" > ${central_file}

# keyspaces + randoms

dump_central "$keyspaces_cond" "keyspaces"

tables=( $(mysql "${mysql_creds[@]}" -D passportdbcentral -N -e "select distinct tablename from keyspaces where $keyspaces_cond") )
dump_central "true limit 10" "${tables[@]}"

dump_central "${test_domains}" domains
dump_central "id < 2" domains_events
dump_central "true" hosts domains_hosts
dump_central "true" stop_words stop_subwords
dump_central "${test_uids}" aliases

# dump shards

dump_passportdbshard "passportdbshard1" ${shard1_file}

dump_passportdbshard "passportdbshard2" ${shard2_file}

#dump oauth central and shards

dump_heading "oauthdbcentral" > ${oauthcentral_file}
mysqldump "${mysql_creds[@]}" "${dump_params[@]}" --where="${test_oauth_clients}" oauthdbcentral "${oauth_central_tables[@]}" >> ${oauthcentral_file}

dump_heading "oauthdbshard1" > ${oauthshard_file}
mysqldump "${mysql_creds[@]}" "${dump_params[@]}" --where="${test_oauth_tokens}" oauthdbshard1 "${oauth_shard_tables[@]}" >> ${oauthshard_file}

dump_heading "oauthdbshard2" > ${oauthshard2_file}
mysqldump "${mysql_creds[@]}" "${dump_params[@]}" --where="${test_oauth_tokens}" oauthdbshard2 "${oauth_shard_tables[@]}" >> ${oauthshard2_file}

# add hardcoded tokens that are returned by OAuth mock
echo "
INSERT INTO \`token_attributes\` VALUES  (5730520,1,'AQAAAADue-GoAAAI22_eZKnwukAEhLSCzDr5FHk'), (5730520,2,'|50|35|'), (5730520,3,'4001096104'), (5730520,4,'2267'), (5730520,5,'-'), (5730520,9,'1545665885'), (5730520,10,'1545665885'), (5730520,11,'p:>\\\\u25D5\\\\u203F\\\\u25D5');


INSERT INTO \`token_by_access_token\` VALUES ('1:2GSaFWYaSKx5+0+XYMZQ2KWwr2DCKs9Z0J3a07Cg+qw',5730520);" >>${oauthshard_file}

# use sed to make dumps humah-readable
for dump in "${central_file}" "${shard1_file}" "${shard2_file}" "${oauthcentral_file}" "${oauthshard_file}"; do
    sed -i 's/\(VALUES \|),\)/\1\n  /g' "${dump}"
done
