import json
import os
import yatest.common as yc

from passport.infra.recipes.common import log, start_daemon
from yatest.common import network


class PushSubsctiptionFixture:
    def __init__(self):
        self._pm = network.PortManager()

        self.http_port = self._pm.get_tcp_port()
        self.xiva_port = self._pm.get_tcp_port()

        tvm_secret_path = yc.output_path('tvm.secret')
        tvm_cache_dir = yc.output_path('tvm_cache')
        ping_path = yc.output_path("ping.html")
        config_path = yc.output_path("config.json")

        try:
            with open('./tvmapi.port') as f:
                tvm_port = int(f.read())
        except IOError:
            log('Could not find tvm port file: ./tvmapi.port')

        with open(tvm_secret_path, 'w') as f:
            f.write("cCuH4v6ASYGdeYJPxZKEGA")

        push_subscription_config = {
            "http_common": {
                "listen_address": "localhost",
                "port": self.http_port,
            },
            "logger": {
                "file": yc.output_path("common.log"),
            },
            "service": {
                "common": {
                    "ping_file": ping_path,
                    "access_log": {
                        "file": yc.output_path("access.log"),
                        "disable_printing_level": True,
                    },
                    "passport_statbox_log": yc.output_path("passport-statbox.log"),
                    "push_subscription_log": yc.output_path("push-subscription.log"),
                },
                "tvm": {
                    "self_tvm_id": 15,
                    "secret_filepath": tvm_secret_path,
                    "disk_cache_dir": tvm_cache_dir,
                    "destinations": {
                        "blackbox": 224,
                        "xiva": 224,
                    },
                    "tvm_host": "http://127.0.0.1",
                    "tvm_port": tvm_port,
                },
                "blackbox": {
                    "url": 'http://localhost:%d' % int(os.environ['RECIPE_BLACKBOX_PORT']),
                    "timeout": "5000ms",
                    "retries": 3,
                },
                "xiva": {
                    "url": 'http://localhost:%d' % self.xiva_port,
                    "timeout": "5000ms",
                    "retries": 3,
                    "service": "passport-push",
                },
            },
        }

        if not os.path.isdir(tvm_cache_dir):
            os.mkdir(tvm_cache_dir)

        with open(ping_path, 'w') as f:
            f.write("Pong")

        with open(config_path, 'w') as f:
            json.dump(push_subscription_config, f, indent=2)

        command = [
            yc.build_path('passport/infra/daemons/push_subscription/ut/xiva_mock/xiva_mock'),
            str(self.xiva_port),
        ]
        self._xiva_process = start_daemon(command, os.environ.copy(), self.xiva_port)

        command = [
            yc.build_path('passport/infra/daemons/push_subscription/cmd/push_subscription'),
            '-c',
            config_path,
        ]
        self._process = start_daemon(command, os.environ.copy(), self.http_port)

    def stop(self):
        self._pm.release()
        self._process.terminate()
        self._xiva_process.terminate()
