package main

import (
	"fmt"
	"net/http"
	"os"
	"strconv"
)

func SimpleHandler(response string) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		w.WriteHeader(http.StatusOK)
		_, err := w.Write([]byte(response))
		if err != nil {
			fmt.Printf("Failed to write response: %s", err)
		}
	}
}

func RunServer(port uint16) {
	fmt.Printf("Starting xiva_mock at port %d\n", port)

	http.HandleFunc("/", SimpleHandler("Mock"))
	http.HandleFunc("/ping", SimpleHandler("Pong"))

	err := http.ListenAndServe(fmt.Sprintf(":%d", port), nil)
	if err != http.ErrServerClosed {
		fmt.Println(err)
	}
}

func main() {
	if len(os.Args) < 2 {
		fmt.Printf("Usage: %s <port>\n", os.Args[0])
		return
	}

	port, err := strconv.ParseUint(os.Args[1], 10, 16)
	if err != nil {
		fmt.Printf("Invalid argument <port>: must be uint, got %s\n", os.Args[1])
		return
	}

	RunServer(uint16(port))
}
