import json
import sys


SETTINGS = {
    "development": {
        "DEBUG": True,
        "SELF_TVM_ID": 2034358,
        "CASSANDRA_HOSTS": [],
    },
    "testing": {
        "DEBUG": True,
        "SELF_TVM_ID": 2034358,
        "CASSANDRA_HOSTS": ["ufo-test.sezam.yandex.net"],
    },
    "production": {
        "DEBUG": False,
        "SELF_TVM_ID": 2034360,
        "CASSANDRA_HOSTS": [
            "ufo-m11.sezam.yandex.net",
            "ufo-m21.sezam.yandex.net",
            "ufo-m51.sezam.yandex.net",
            "ufo-s1.sezam.yandex.net",
            "ufo-s2.sezam.yandex.net",
            "ufo-s3.sezam.yandex.net",
            "ufo-i11.sezam.yandex.net",
            "ufo-i41.sezam.yandex.net",
            "ufo-i81.sezam.yandex.net",
            "ufo-f1.sezam.yandex.net",
            "ufo-f2.sezam.yandex.net",
            "ufo-v1.sezam.yandex.net",
            "ufo-v2.sezam.yandex.net",
            "ufo-v3.sezam.yandex.net",
        ],
    },
}


def do(template, env):
    if env not in SETTINGS:
        raise Exception("env '%s' is unknown" % env)

    setts = SETTINGS[env]
    for key, value in setts.items():
        template = template.replace('<<%s>>' % key, json.dumps(value) if isinstance(value, list) else str(value))

    if '<<' in template or '>>' in template:
        raise Exception("some options were not specified: %s\n" % template)

    print(template)


if __name__ == '__main__':
    if len(sys.argv) != 3:
        print("Usage: %s <template_file> <env>" % (sys.argv[0]))
        sys.exit(1)

    with open(sys.argv[1]) as f:
        template = f.read()
        assert len(template) > 0

    do(template, sys.argv[2])
