from __future__ import print_function

import sys


def xml_list(tag, arr):
    res = ''
    for i in arr:
        res += '          <%s>%s</%s>\n' % (tag, i, tag)
    if res.endswith('\n'):
        res = res[:-1]
    return res


def domain_list(arr):
    return xml_list('domain', arr)


SETTINGS = {
    "autotest": {
        "THREADS": 8,
        "BB_POOL_SIZE": 8,
        "BB_HOST": "localhost",
        "ORIGIN_POLICY": "strict",
        "SIDE_DOMAINS_ACCOUNTS_EXTRA": "",
        "SIDE_DOMAINS_REG_COMPLETION_RECOMMENDED": domain_list(['auto.ru']),
        "TVM_SELF_ID": 258,
        "TVM_BB_ID": 224,
        "LRCS_TTL": 2592000,
    },
    "testing": {
        "THREADS": 8,
        "BB_POOL_SIZE": 8,
        "BB_HOST": "blackbox-test.yandex.net",
        "ORIGIN_POLICY": "relaxed",
        "SIDE_DOMAINS_ACCOUNTS_EXTRA": domain_list(
            [
                'avto.ru',
                'dev.vertis.yandex.net',
            ]
        ),
        "SIDE_DOMAINS_REG_COMPLETION_RECOMMENDED": "",
        "TVM_SELF_ID": 2000027,
        "TVM_BB_ID": 224,
        "LRCS_TTL": 86400,
    },
    "testing.intranet": {
        "THREADS": 8,
        "BB_POOL_SIZE": 8,
        "BB_HOST": "blackbox-test.yandex-team.ru",
        "ORIGIN_POLICY": "strict",
        "SIDE_DOMAINS_ACCOUNTS_EXTRA": "",
        "SIDE_DOMAINS_REG_COMPLETION_RECOMMENDED": "",
        "TVM_SELF_ID": 2019153,
        "TVM_BB_ID": 225,
        "LRCS_TTL": 86400,
    },
    "rc": {
        "THREADS": 8,
        "BB_POOL_SIZE": 8,
        "BB_HOST": "blackbox.yandex.net",
        "ORIGIN_POLICY": "strict",
        "SIDE_DOMAINS_ACCOUNTS_EXTRA": "",
        "SIDE_DOMAINS_REG_COMPLETION_RECOMMENDED": "",
        "TVM_SELF_ID": 2000028,
        "TVM_BB_ID": 222,
        "LRCS_TTL": 2592000,
    },
    "production": {
        "THREADS": 64,
        "BB_POOL_SIZE": 64,
        "BB_HOST": "blackbox.yandex.net",
        "ORIGIN_POLICY": "strict",
        "SIDE_DOMAINS_ACCOUNTS_EXTRA": "",
        "SIDE_DOMAINS_REG_COMPLETION_RECOMMENDED": "",
        "TVM_SELF_ID": 2000028,
        "TVM_BB_ID": 222,
        "LRCS_TTL": 2592000,
    },
    "production.intranet": {
        "THREADS": 8,
        "BB_POOL_SIZE": 8,
        "BB_HOST": "blackbox.yandex-team.ru",
        "ORIGIN_POLICY": "strict",
        "SIDE_DOMAINS_ACCOUNTS_EXTRA": "",
        "SIDE_DOMAINS_REG_COMPLETION_RECOMMENDED": "",
        "TVM_SELF_ID": 2019151,
        "TVM_BB_ID": 223,
        "LRCS_TTL": 2592000,
    },
    "development": {
        "THREADS": 8,
        "BB_POOL_SIZE": 8,
        "BB_HOST": "blackbox-test.yandex.net",
        "ORIGIN_POLICY": "strict",
        "SIDE_DOMAINS_ACCOUNTS_EXTRA": domain_list(
            [
                'avto.ru',
                'dev.vertis.yandex.net',
            ]
        ),
        "SIDE_DOMAINS_REG_COMPLETION_RECOMMENDED": domain_list(['auto.ru']),
        "TVM_SELF_ID": 2000027,
        "TVM_BB_ID": 224,
        "LRCS_TTL": 2592000,
    },
}


for pr in ["autotest", "testing", "rc", "production", "development"]:
    SETTINGS[pr].update(
        {
            "YANDEX_SLD": "yandex",
            "YANDEX_TLD": domain_list(
                [
                    'az',
                    'by',
                    'co.il',
                    'com.am',
                    'com.ge',
                    'com.tr',
                    'com',
                    'ee',
                    'eu',
                    'fi',
                    'fr',
                    'kg',
                    'kz',
                    'lt',
                    'lv',
                    'md',
                    'pl',
                    'ru',
                    'tj',
                    'tm',
                    'ua',
                    'uz',
                ]
            ),
            "SIDE_DOMAINS_DEFAULT": domain_list(
                [
                    'kinopoisk.ru',
                ]
            ),
            "SIDE_DOMAINS_ACCOUNTS": domain_list(
                [
                    'auto.ru',
                    'dzen.ru',
                    'kinopoisk.ru',
                    'thequestion.ru',
                    'yango.delivery',
                ]
            ),
        }
    )


for pr in ["testing.intranet", "production.intranet"]:
    SETTINGS[pr].update(
        {
            "YANDEX_SLD": "yandex-team",
            "YANDEX_TLD": domain_list(['ru']),
            "SIDE_DOMAINS_DEFAULT": "",
            "SIDE_DOMAINS_ACCOUNTS": "",
        }
    )


def do(template, env):
    if env not in SETTINGS:
        raise Exception("env '%s' is unknown" % env)

    setts = SETTINGS[env]
    for key, value in setts.items():
        template = template.replace('{{%s}}' % key, str(value))

    if '{{' in template or '}}' in template:
        raise Exception("some options were not specified: %s\n" % template)

    print(template)


if __name__ == '__main__':
    if len(sys.argv) != 4:
        print("Usage: %s <template_file> <env_type> <env_name>" % (sys.argv[0]))
        sys.exit(1)

    with open(sys.argv[1]) as f:
        template = f.read()
        assert len(template) > 0

    env = sys.argv[2] if sys.argv[3] == "" else "%s.%s" % (sys.argv[2], sys.argv[3])

    do(template, env)
