#include "cookie_parser.h"

#include <passport/infra/libs/cpp/utils/string/coder.h>
#include <passport/infra/libs/cpp/utils/string/string_utils.h>

#include <passport/protobuf/cookie_lah/cookie_lah.pb.h>

namespace NPassport::NSezamApi {
    static TLahCookieParser::TParseResult GenerateResult(const TString& decoded) {
        cookie_login_suggest::AuthHistoryContainer proto;
        if (!proto.ParseFromString(decoded)) {
            return {
                .ErrorMessage = "Malformed protobuf in cookie",
            };
        }

        TLahCookieParser::TParseResult result;
        for (int idx = 0; idx < proto.auth_history_items_size(); ++idx) {
            const cookie_login_suggest::AuthHistoryItem& item = proto.auth_history_items(idx);
            result.Accounts.insert({item.uid(), item.timestamp(), item.method()});
        }

        return result;
    }

    TLahCookieParser::TParseResult TLahCookieParser::ParseV2(const TBaseCheckSignFetcher& fetcher, TStringBuf cookie) {
        if (!cookie.SkipPrefix("2:")) {
            return {
                .ErrorMessage = "Malformed cookie",
            };
        }

        TString encoded;
        try {
            encoded = fetcher.Fetch(cookie);
        } catch (const std::exception& e) {
            return {
                .ErrorMessage = e.what(),
            };
        }
        TString decoded = NUtils::Base64url2bin(encoded);
        if (decoded.empty()) {
            return {
                .ErrorMessage = "Bad base64url in cookie",
            };
        }

        return GenerateResult(decoded);
    }
}
