#pragma once

#include <passport/infra/libs/cpp/dbpool/query.h>
#include <passport/infra/libs/cpp/request/request.h>

#include <util/generic/string.h>

namespace NPassport::NDbPool {
    class TDbPool;
}

namespace NBlackbox2 {
    class TSessionResp;
}

namespace NPassport::NSezamApi {
    static const TString COOKIE_YP_ = "yp";

    struct TRegCompletionArgs {
        TString Sessionid;
        TString Sessguard;
        TString Domain;
        TString Userip;
        std::optional<TString> YPCookie;

        TString ToQuery() const;
    };

    class TRegCompletionRecommended {
    public:
        static bool CheckRegCompletionRecommended(NDbPool::TDbPool& db,
                                                  const TRegCompletionArgs& args);

        static TString SerializeRegCompletionRecommended(bool checkRegistrationCompleted);
        static NDbPool::TQuery BuildBbQuery(const TRegCompletionArgs& args);

        static TString GetConnectionId(NDbPool::TDbPool& db, const TRegCompletionArgs& args);
        static void SetLrcsToYpCookie(NCommon::TRequest& req, ui32 lrcsExpirationTtl, TInstant now = TInstant::Now());
        static const TString& DefaultAnswer();

    private:
        static THolder<NBlackbox2::TSessionResp> GetBbSessionIdResponse(NDbPool::TDbPool& db, const TRegCompletionArgs& args);
    };

    void CheckRegCompetionRecommendedBlackboxGrants(NDbPool::TDbPool& bb);
}
