#pragma once

#include <passport/infra/daemons/sezamapi/src/utils/origin.h>

#include <passport/infra/libs/cpp/tvm/common/service_tickets.h>

#include <util/generic/string.h>

#include <memory>
#include <unordered_map>
#include <vector>

namespace NTvmAuth {
    class TTvmClient;
}
namespace NPassport::NXml {
    class TConfig;
}
namespace NPassport::NDbPool {
    class TDbPool;
    class TDbPoolCtx;
}
namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NSezamApi {
    class TLKeysLoader;

    class TRuntimeContext {
    public:
        TRuntimeContext(const NXml::TConfig& config, const TString& path);
        ~TRuntimeContext();

        bool IsForceDown() const;
        void AddUnistat(NUnistat::TBuilder& builder) const;
        NDbPool::TDbPool& Bb();
        const TLKeysLoader& Lkeys() const;

        bool IsOk(TString& out) const;

        struct TTimingsConfig {
            ui32 DoNotDisturbAfterClose = 0;
            ui32 DoNotDisturbAfterCloseMin = 0;
            ui32 DoNotDisturbAfterCloseMax = 0;
            ui32 DoNotDisturbAfterShow = 0;
            ui32 DoNotDisturbAfterShowMin = 0;
            ui32 DoNotDisturbAfterShowMax = 0;
            ui32 IlahuTtl = 0;
            ui32 LrcsExpirationTtl = 0;
        };

        struct TMethodsConfig {
            std::unordered_map<ui32, TString> Mapping;
        };

        struct TOrigins {
            TOriginPtr YandexTld;
            TOriginPtr SideDomainsDefault;
            TOriginPtr SideDomainsForAccounts;
            TOriginPtr SideDomainsForRegCompletionRecommended;
        };

        const TTimingsConfig& GetTimingsCfg() const {
            return TimingsCfg_;
        }

        const TMethodsConfig& GetMethodsCfg() const {
            return MethodsCfg_;
        }

        const TOrigins& GetOrigins() const {
            return *Origins_;
        }

    private:
        void InitTvm(const NXml::TConfig& config, const TString& path);
        void InitMethods(const NXml::TConfig& config, const TString& path);

        static TOrigin::EPolicy PolicyFromString(const TString& s);
        static std::vector<TString> DomainListFromCfg(const NXml::TConfig& config, const TString& p);

    private:
        TString ForceDownFile_;
        std::shared_ptr<NDbPool::TDbPool> Bb_;
        std::shared_ptr<NDbPool::TDbPoolCtx> DbCtx_;
        std::unique_ptr<TOrigins> Origins_;
        std::shared_ptr<NTvmAuth::TTvmClient> TvmClient_;

        TTimingsConfig TimingsCfg_;
        TMethodsConfig MethodsCfg_;
    };
}
