#pragma once

#include <passport/infra/libs/cpp/request/request.h>
#include <passport/infra/libs/cpp/unistat/consumers.h>
#include <passport/infra/libs/cpp/unistat/handle.h>

#include <util/generic/string.h>

#include <memory>

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NXml {
    class TConfig;
}

namespace NPassport::NSezamApi {
    class TAccountsSettings;
    class TOrigin;
    class TRuntimeContext;
    class TSuggestProcessor;
    enum class EOnlyValidUsers;

    class TSezamApi {
    public:
        TSezamApi();
        ~TSezamApi();

        void Init(const NXml::TConfig& config);

        void HandleRequest(NCommon::TRequest& request);

        void AddUnistat(NUnistat::TBuilder& builder);
        void AddUnistatExtended(const TString& path, NUnistat::TBuilder& builder);

    private:
        static void CheckDuplicatedArgs(const NCommon::TRequest& req);
        void ChooseMethod(NCommon::TRequest& req);

        void ProcessGet(NCommon::TRequest& req, TStringBuf path);
        void ProcessPost(NCommon::TRequest& req, TStringBuf path);
        void ProcessOptions(NCommon::TRequest& req, TStringBuf path);

        void ProcessScriptNagios(NCommon::TRequest& req);
        void ProcessScriptSuggest(NCommon::TRequest& req);
        void ProcessScriptCloseSuggest(NCommon::TRequest& req);
        void ProcessScriptSuggestShowAndPostpone(NCommon::TRequest& req);
        void ProcessScriptAccounts(NCommon::TRequest& req, EOnlyValidUsers onlyValidUsers);
        void ProcessScriptRegistrationStatusCheck(NCommon::TRequest& req);
        void ProcessScriptRegistrationStatusPostpone(NCommon::TRequest& req);

        static bool CheckCsrf(const NCommon::TRequest& req);
        void DefaultProcessing(NCommon::TRequest& req, const TOrigin* originChecker);
        void DefaultProcessing(NCommon::TRequest& req);
        void SetHeaderIlahu(NCommon::TRequest& req, time_t curIlahu, ui32 doNotDistrub);
        TSuggestProcessor CreateSuggestProcessor(const NCommon::TRequest& request) const;

        static TString GetDomain(const TString& host);

        void CheckGrants();

    private:
        std::unique_ptr<TRuntimeContext> Runtime_;
        std::unique_ptr<TAccountsSettings> AccountsSettings_;

        THashMap<TString, std::function<void(NCommon::TRequest&, TStringBuf)>> HandlersMethod_;
        THashMap<TString, std::function<void(NCommon::TRequest&)>> HandlersGet_;
        THashMap<TString, std::function<void(NCommon::TRequest&)>> HandlersPost_;

        NUnistat::THandles UnistatHandles_;
        NUnistat::TSimpleConsumers UnistatOrigins_;
    };
}
