#pragma once

#include <passport/infra/libs/cpp/xml/config.h>

#include <util/generic/string.h>

#include <map>
#include <memory>
#include <optional>
#include <variant>
#include <vector>

namespace NGeobase {
    class TLookup;
}

namespace NPassport::NDbPool {
    class TDbPool;
}
namespace NPassport::NJson {
    class TObject;
}

namespace NPassport::NSezamApi {
    class TAccountsSettings {
    public:
        TAccountsSettings(const NXml::TConfig& config, const TString& path);
        ~TAccountsSettings();

        bool InPlusDomain(const TString& host) const;
        bool IsRussia(const TString& userip) const;

        bool PlusForPdd() const {
            return PlusForPdd_;
        }

    private:
        bool PlusForPdd_ = true;
        std::unique_ptr<NGeobase::TLookup> Lookup_;
        // we suppose there will be only one plusDomain here
        std::vector<TString> PlusDomains_;
    };

    struct TPersonalInfo {
        TString Uid;
        TString Login;
        TString DisplayName;
        std::optional<TString> FirstName;
        std::optional<TString> LastName;
        TString DefaultEmail;
        bool Social = false;
        TString ProfileId;
        TString Provider;
        TString DefaultAvatar;

        using TAttrMap = std::map<TString, std::variant<TString, bool, ui32>>;
        TAttrMap Attributes;

        void Serialize(NJson::TObject& buf) const;
    };

    struct TAccounts {
        TAccounts(int count, bool more)
            : CanMore(more)
        {
            Users.resize(count);
        }
        std::vector<TPersonalInfo> Users;
        TString DefaultUid;
        bool CanMore;
    };

    bool PlusAvailable(const TAccountsSettings& settings,
                       const TString& userip, const TString& domain,
                       bool isPdd, bool isStaff);

    enum class EOnlyValidUsers {
        True,
        False,
    };

    enum class EAddNames {
        True,
        False,
    };

    enum class EAddOrganizationInfo {
        True,
        False,
    };

    struct TAccountsArgs {
        TString Sessionid;
        TString Sessguard;
        TString Domain;
        TString Userip;

        EOnlyValidUsers OnlyValidUsers = EOnlyValidUsers::False;
        EAddNames AddNames = EAddNames::False;
        EAddOrganizationInfo AddOrganizationInfo = EAddOrganizationInfo::False;
    };

    std::unique_ptr<TAccounts> GetAccountsFromBb(
        NDbPool::TDbPool& db,
        const TAccountsSettings& settings,
        const TAccountsArgs& args);

    void CheckAccountBlackboxGrants(NDbPool::TDbPool& bb);

    TString SerializeAccountsList(const TAccounts* accounts = nullptr);
}
