#pragma once

#include "runtime_context.h"

#include <util/generic/string.h>

#include <set>

namespace NPassport::NCommon {
    class TRequest;
}
namespace NPassport::NDbPool {
    class TDbPool;
}

namespace NPassport::NSezamApi {
    class TLahCookieParser;
    struct TAccountInfo;
    struct TLahAccount;
    using TLahAccounts = std::set<TLahAccount>;
    using TAccountsInfo = std::set<TAccountInfo>;
}

namespace NPassport::NSezamApi {
    class TSuggestProcessor {
    public:
        enum class ENeed {
            All,
            One
        };

        TSuggestProcessor(NDbPool::TDbPool& bb,
                          const NCommon::TRequest& request,
                          const TRuntimeContext::TMethodsConfig& methodsMapping);

        TString Process(TStringBuf cookie, ENeed need);
        bool IsSuccessful() const;

        static void CheckBlackboxGrants(NDbPool::TDbPool& bb);

        static const TString& Fallback();

    public:
        static TString SerializeJson(const TLahAccounts& accounts,
                                     const TAccountsInfo& info,
                                     ENeed need,
                                     const TRuntimeContext::TMethodsConfig& methodsMapping,
                                     const TString& yu = TString());

    private:
        NDbPool::TDbPool& Bb_;
        TString Res_;
        const NCommon::TRequest& Req_;
        const TRuntimeContext::TMethodsConfig& MethodsMapping_;
    };

}
