#pragma once

#include <util/generic/string.h>

#include <set>

namespace NPassport::NSezamApi {
    struct TAccountInfo {
        TString Uid;
        TString DisplayName;
        TString Avatar;
        bool IsEmpty = false;
        time_t Glogout = 0;
        time_t RevokeSessions = 0;

        bool operator==(const TAccountInfo& o) const {
            return Uid == o.Uid &&
                   DisplayName == o.DisplayName &&
                   Avatar == o.Avatar &&
                   IsEmpty == o.IsEmpty &&
                   Glogout == o.Glogout &&
                   RevokeSessions == o.RevokeSessions;
        }
    };

    using TAccountsInfo = std::set<TAccountInfo>;
}

template <>
struct std::less<NPassport::NSezamApi::TAccountInfo> {
    bool operator()(const NPassport::NSezamApi::TAccountInfo& lhs, const NPassport::NSezamApi::TAccountInfo& rhs) const {
        return lhs.Uid < rhs.Uid;
    }
    bool operator()(const TString& lhs, const NPassport::NSezamApi::TAccountInfo& rhs) const {
        return lhs < rhs.Uid;
    }
    bool operator()(const NPassport::NSezamApi::TAccountInfo& lhs, const TString& rhs) const {
        return lhs.Uid < rhs;
    }
    using is_transparent = std::true_type;
};
