#pragma once

#include "account_info.h"
#include "utils.h"

#include <passport/infra/libs/cpp/dbpool/query.h>
#include <passport/infra/libs/cpp/dbpool/util.h>
#include <passport/infra/libs/cpp/utils/string/string_utils.h>

namespace NPassport::NSezamApi {
    template <class T, class K>
    class TBaseBbFetcher {
    public:
        virtual T Fetch(const K&) const = 0;
    };

    template <class T, class K>
    class TBbFetcher: public TBaseBbFetcher<T, K> {
    public:
        explicit TBbFetcher(NDbPool::TDbPool& bb)
            : TBaseBbFetcher<T, K>()
            , Bb_(bb)
        {
        }

        T Fetch(const K& data) const override {
            return ParseBbResponse(GetBbResponse(data));
        }

        void CheckGrants() const {
            TUtils::CheckBlackboxGrants(Bb_, BuildBbQuery({}));
        }

    protected:
        TString GetBbResponse(const K& data) const {
            return NDbPool::NUtils::GetHttpBody(Bb_, BuildBbQuery(data), "Cannot get response from BB");
        }

        virtual T ParseBbResponse(TStringBuf) const = 0;

        virtual NDbPool::TQuery BuildBbQuery(const K&) const = 0;

    private:
        NDbPool::TDbPool& Bb_;
    };

    class TBbCheckSignFetcher: public TBbFetcher<TString, TStringBuf> {
    public:
        explicit TBbCheckSignFetcher(NDbPool::TDbPool& bb)
            : TBbFetcher<TString, TStringBuf>(bb)
        {
        }

    protected:
        TString ParseBbResponse(TStringBuf data) const override;

        NDbPool::TQuery BuildBbQuery(const TStringBuf& data) const override;
    };
    using TBaseCheckSignFetcher = TBaseBbFetcher<TString, TStringBuf>;

    class TBbAccountsFetcher: public TBbFetcher<TAccountsInfo, TLahAccounts> {
    public:
        explicit TBbAccountsFetcher(NDbPool::TDbPool& bb)
            : TBbFetcher<TAccountsInfo, TLahAccounts>(bb)
        {
        }

    protected:
        TAccountsInfo ParseBbResponse(TStringBuf data) const override;

        NDbPool::TQuery BuildBbQuery(const TLahAccounts& accounts) const override;
    };
}
