#pragma once

#include <util/generic/string.h>
#include <util/system/types.h>

#include <set>

namespace NPassport::NSezamApi {
    struct TLahAccount {
        ui64 Uid = 0;
        time_t LastLoginTime = 0;
        ui32 LoginMethod = 0;
    };

    inline bool operator<(const TLahAccount& lhs, const TLahAccount& rhs) {
        if (lhs.LoginMethod && !rhs.LoginMethod) {
            return true;
        }
        if (!lhs.LoginMethod && rhs.LoginMethod) {
            return false;
        }
        if (lhs.LastLoginTime != rhs.LastLoginTime) {
            return lhs.LastLoginTime > rhs.LastLoginTime;
        }
        if (lhs.Uid != rhs.Uid) {
            return lhs.Uid < rhs.Uid;
        }
        return lhs.LoginMethod < rhs.LoginMethod;
    }

    inline bool operator==(const TLahAccount& lhs, const TLahAccount& rhs) {
        return lhs.Uid == rhs.Uid &&
               lhs.LastLoginTime == rhs.LastLoginTime &&
               lhs.LoginMethod == rhs.LoginMethod;
    }

    using TLahAccounts = std::set<TLahAccount>;

}
