#pragma once

#include <passport/infra/libs/cpp/re2/regex.h>

#include <util/generic/strbuf.h>
#include <util/generic/string.h>

#include <optional>
#include <regex>
#include <vector>

namespace NPassport::NSezamApi {
    class TOrigin;
    using TOriginPtr = std::unique_ptr<TOrigin>;

    class TOrigin {
    public:
        enum class EPolicy {
            Strict,
            Relaxed,
        };
        using TDomains = std::vector<TString>;

        static TOriginPtr CreateForYandexTld(EPolicy policy, const TString& sld, const TDomains& domains);
        static TOriginPtr CreateForSideDomains(EPolicy policy, const TDomains& domains);

        std::optional<TString> Check(const TStringBuf origin) const;

    public:
        static TString RegexForYandexTld(EPolicy policy, const TString& sld, const TDomains& domains);
        static TString RegexForSideDomains(EPolicy policy, const TDomains& domains);

    public:
        TOrigin(TStringBuf regex, TStringBuf outFormat);

    private:
        NRe2::TReplacingRegex Regex_;
    };
}
