#include "utils.h"

#include <passport/infra/libs/cpp/dbpool/handle.h>
#include <passport/infra/libs/cpp/dbpool/util.h>
#include <passport/infra/libs/cpp/request/request.h>
#include <passport/infra/libs/cpp/utils/string/split.h>

#include <passport/protobuf/cookie_lah/cookie_lah.pb.h>

#include <util/string/subst.h>

namespace NPassport::NSezamApi {
    static const TString COOKIE_YANDEXUID = "yandexuid";
    static const size_t SKIP_DOMAIN_PARTS_NUM = 2;

    void TUtils::LogIgnore(const NCommon::TRequest& req, const TStringBuf msg) {
        TLog::Debug() << "Ignore request: " << msg << ". yu=" << req.GetCookie(COOKIE_YANDEXUID);
    }

    ui32 TUtils::GetPostponeDelay(TStringBuf arg, ui32 minVal, ui32 maxVal, ui32 defaultVal) {
        ui32 res = 0;
        return TryIntFromString<10>(arg, res) && minVal <= res && res <= maxVal
                   ? res
                   : defaultVal;
    }

    void TUtils::CheckBlackboxGrants(NDbPool::TDbPool& bb,
                                     NDbPool::TQuery&& query) {
        TString path = query.Query();
        SubstGlobal(path, "/blackbox", "/blackbox/check_grants");
        query.SetQuery(path);

        NDbPool::TBlockingHandle h(bb);
        NDbPool::THttpResponse response = h.Query(std::move(query))->ToHttpResponse();

        Y_ENSURE(response.Status == 200,
                 "Failed to check grants: "
                     << "code=" << response.Status
                     << ". request: " << path
                     << ". response: " << response.Body);
    }

    TString TUtils::SerializeLahData(const TLahAccounts& accs) {
        cookie_login_suggest::AuthHistoryContainer proto;
        for (const NSezamApi::TLahAccount& acc : accs) {
            cookie_login_suggest::AuthHistoryItem* item = proto.add_auth_history_items();
            item->set_version(1);
            item->set_uid(acc.Uid);
            item->set_timestamp(acc.LastLoginTime);
            item->set_method(acc.LoginMethod);
        }

        return proto.SerializeAsString();
    }

    time_t TUtils::GetTsFromCookie(const TString& cookie) {
        time_t ts = 0;
        return TryIntFromString<10>(cookie, ts) ? ts : 0;
    }

    TString TUtils::GetDomain(const TString& host) {
        // skip 'api' in 'api.passport.yandex.ru'
        return host.substr(3);
    }

    TString TUtils::PrepareYpCookieDomain(TStringBuf domain) {
        TStringBuf nextPart;
        size_t passedParts = 0;

        while (passedParts < SKIP_DOMAIN_PARTS_NUM && domain.NextTok('.', nextPart)) {
            passedParts++;
        }

        return TString(domain);
    }

}
