#pragma once

#include "lah_account.h"

#include <passport/infra/libs/cpp/dbpool/query.h>

#include <util/generic/yexception.h>

namespace NPassport::NCommon {
    class TRequest;
}

namespace NPassport::NDbPool {
    class TDbPool;
}

namespace NPassport::NSezamApi {
    class TUtils {
    public:
        static void LogIgnore(const NCommon::TRequest& req, const TStringBuf msg);
        static ui32 GetPostponeDelay(TStringBuf arg, ui32 minVal, ui32 maxVal, ui32 defaultVal);

        static TString SerializeLahData(const TLahAccounts& accs);

        static void CheckBlackboxGrants(NDbPool::TDbPool& bb,
                                        NDbPool::TQuery&& query);
        static time_t GetTsFromCookie(const TString& cookie);
        static TString GetDomain(const TString& host);
        static TString PrepareYpCookieDomain(TStringBuf originalDomain);
    };

    class TBackendException: public yexception {
    };
}
