#include <passport/infra/daemons/sezamapi/src/reg_completion_handles/reg_completion_recommended.h>

#include <passport/infra/libs/cpp/request/test/request.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NSezamApi;

Y_UNIT_TEST_SUITE(RegCompletionRecommendedTest) {
    Y_UNIT_TEST(serialize) {
        UNIT_ASSERT_STRINGS_EQUAL(R"({"is_completion_recommended":true})",
                                  TRegCompletionRecommended::SerializeRegCompletionRecommended(true));
        UNIT_ASSERT_STRINGS_EQUAL(R"({"is_completion_recommended":false})",
                                  TRegCompletionRecommended::SerializeRegCompletionRecommended(false));
    }

    Y_UNIT_TEST(buildRequest) {
        TRegCompletionArgs args{"Sess", "SessGuard", "domain", "1.2.3.4", std::nullopt};
        {
            NDbPool::TQuery query = TRegCompletionRecommended::BuildBbQuery(args);
            UNIT_ASSERT_STRINGS_EQUAL("/blackbox", query.Query());
            UNIT_ASSERT_STRINGS_EQUAL("method=sessionid&sessionid=Sess&host=domain&userip=1%2E2%2E3%2E4&sessguard=SessGuard", query.HttpBody());
        }
        TRegCompletionArgs argsWithYpCookie{"Sess", "SessGuard", "domain", "1.2.3.4", "expire.name.value"};
        {
            NDbPool::TQuery query = TRegCompletionRecommended::BuildBbQuery(argsWithYpCookie);
            UNIT_ASSERT_STRINGS_EQUAL("/blackbox", query.Query());
            UNIT_ASSERT_STRINGS_EQUAL("method=sessionid&sessionid=Sess&host=domain&userip=1%2E2%2E3%2E4&get_reg_completion_recommendation_with_yp=expire.name.value&sessguard=SessGuard", query.HttpBody());
        }
    }

    Y_UNIT_TEST(updateYpWithLrcs) {
        const TInstant now = TInstant::ParseIso8601("2022-04-01T11:00:00Z");
        NPassport::NTest::TRequest req;
        req.Host = "api.passport.yandex.ru";

        TRegCompletionRecommended::SetLrcsToYpCookie(req, 1000, now);
        UNIT_ASSERT_STRINGS_EQUAL(req.GetCookie("yp"), "1648811800.lrcs.1648810800");
        UNIT_ASSERT_STRINGS_EQUAL(req.GetOutCookie("yp").Domain(), "yandex.ru");

        req.SetCookie(NCommon::TCookie(COOKIE_YP_, "expire.name.value#1648811800.lrcs.100#expire.name2.value"));
        TRegCompletionRecommended::SetLrcsToYpCookie(req, 1000, now);
        UNIT_ASSERT_STRINGS_EQUAL(req.GetCookie("yp"), "expire.name.value#1648811800.lrcs.1648810800#expire.name2.value");

        req.SetCookie(NCommon::TCookie(COOKIE_YP_, "expire.name.value"));
        TRegCompletionRecommended::SetLrcsToYpCookie(req, 1000, now);
        UNIT_ASSERT_STRINGS_EQUAL(req.GetCookie("yp"), "expire.name.value#1648811800.lrcs.1648810800");

        req.SetCookie(NCommon::TCookie(COOKIE_YP_, "..name.value"));
        TRegCompletionRecommended::SetLrcsToYpCookie(req, 1000, now);
        UNIT_ASSERT_STRINGS_EQUAL(req.GetCookie("yp"), "..name.value");
        UNIT_ASSERT_EQUAL(req.Status, HttpCodes::HTTP_PARTIAL_CONTENT);
    }
}
