#include <passport/infra/daemons/sezamapi/src/sids/sids_accounts.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NSezamApi;

Y_UNIT_TEST_SUITE(SidsTest) {
    Y_UNIT_TEST(serialize) {
        UNIT_ASSERT_STRINGS_EQUAL("{}", SerializeAccountsList());

        TAccounts accs(1, true);
        accs.DefaultUid = "4000849384";
        UNIT_ASSERT_STRINGS_EQUAL(R"({"default_uid":"4000849384","can-add-more":true,"accounts":[]})",
                                  SerializeAccountsList(&accs));

        accs.Users.push_back({});
        TPersonalInfo& info = accs.Users.back();
        info.DefaultEmail = "cerevra@yandex.ru";
        info.Login = "cerevra";
        info.Uid = "4000849384";
        info.DefaultAvatar = "0/0-0";
        info.DisplayName = "cerevra2";
        UNIT_ASSERT_STRINGS_EQUAL(R"({"default_uid":"4000849384","can-add-more":true,"accounts":[{"uid":"4000849384","login":"cerevra","displayName":{"name":"cerevra2","default_avatar":"0\/0-0"},"defaultEmail":"cerevra@yandex.ru","attributes":{}}]})",
                                  SerializeAccountsList(&accs));

        info.FirstName = "";
        info.LastName = "";
        UNIT_ASSERT_STRINGS_EQUAL(R"({"default_uid":"4000849384","can-add-more":true,"accounts":[{"uid":"4000849384","login":"cerevra","displayName":{"name":"cerevra2","firstname":"","lastname":"","default_avatar":"0\/0-0"},"defaultEmail":"cerevra@yandex.ru","attributes":{}}]})",
                                  SerializeAccountsList(&accs));

        info.FirstName = "Вася";
        info.LastName = "Пупкин";
        UNIT_ASSERT_STRINGS_EQUAL(R"({"default_uid":"4000849384","can-add-more":true,"accounts":[{"uid":"4000849384","login":"cerevra","displayName":{"name":"cerevra2","firstname":"\u0412\u0430\u0441\u044F","lastname":"\u041F\u0443\u043F\u043A\u0438\u043D","default_avatar":"0\/0-0"},"defaultEmail":"cerevra@yandex.ru","attributes":{}}]})",
                                  SerializeAccountsList(&accs));
    }
}
