#!/bin/bash

# This script dumps some data from test db to use it as standalone test database
set -o errexit

# config files (databases) to dump:
readonly central_file='central.sql'
readonly shard1_file='shard1.sql'
readonly shard2_file='shard2.sql'
readonly oauthcentral_file='oauth_central.sql'
readonly oauthshard_file='oauth_shard.sql'
readonly oauthshard2_file='oauth_shard2.sql'

# dump options
readonly mysql_creds=("-h" "cnt-dbm-test.passport.yandex.net" "-P" "3306" "-u" "$BB_PASSPORTDB_USER_RW" "-p$BB_PASSPORTDB_PASSWD_RW")
readonly dump_params=("--skip-set-charset" "--add-locks" "--set-gtid-purged=OFF" "--skip-comments" "--single-transaction" "--disable-keys" "--no-tablespaces") # "--skip-extended-insert")


# selected data to dump
readonly shard_tables=("attributes" "extended_attributes" \
 "email_bindings" "phone_bindings" "phone_bindings_history" "phone_operations"\
 "account_deletion_operations" "passman_recovery_keys" "password_history" "tracks")
readonly oauth_central_tables=("client_attributes" "client_by_owner" "client_by_params" "client_by_uid")
readonly oauth_shard_tables=("token_attributes" "token_by_access_token" "token_by_alias")

readonly test_uids="uid in (70495,70496,70497,70499,70500,70502,71004,71011,71016,1130000000035962,1130000000000015)"
readonly test_domains="domain_id in (1,4)"
readonly test_reserved_logins="login in ('')"
readonly test_phones="phone_number in ('')"

readonly test_oauth_clients="id in (1)"
readonly test_oauth_tokens="id in (1)"

readonly keyspaces_cond='domainsuff in (
  "yandex_by",
  "yandex_com_tr",
  "yandex_com",
  "yandex_kz",
  "yandex_ru",
  "yandex_ua",

  "beru_ru",
  "edadeal_ru",

  "cookiel",

  "signsmth",
  "signsmth_long",

  "guard_passport",
  "guard_oauth",
  "guard_test_1",
  "guard_test_2",
  "guard_test_dryrun",

  "oauth"
)'


dump_heading() {
    local db_name="$1"

    echo -e "\n-- CAUTION: This file is generated by make_dump.sh script."
    echo -e "-- Do not edit this file, or else all your changes will be discarded!\n\n"
    echo -e "CREATE DATABASE \`${db_name}\`;\nUSE \`${db_name}\`;\n\n"
}

dump_central() {
    local condition="$1"
    shift
    local tables=("$@")

    mysqldump "${mysql_creds[@]}" "${dump_params[@]}" --where="${condition:-true}" passportdbcentral "${tables[@]}" >> ${central_file}

    echo -e "\n\n" >> ${central_file}
}

# dump central

dump_heading "passportdbcentral" > ${central_file}

# keyspaces + randoms
dump_central "$keyspaces_cond" "keyspaces"

tables=( $(mysql "${mysql_creds[@]}" -D passportdbcentral -N -e "select distinct tablename from keyspaces where $keyspaces_cond") )
dump_central "true limit 10" "${tables[@]}"

# domains, domains_events, hosts, stop_words, stop_subwords, reserved_logins, aliases, suid2
dump_central "${test_domains}" domains
dump_central "id < 2" domains_events
dump_central "true" hosts domains_hosts
dump_central "true" stop_words stop_subwords
dump_central "${test_reserved_logins}" reserved_logins
dump_central "${test_phones}" yakey_backups
dump_central "${test_uids}" aliases suid2

# dump shards

dump_heading "passportdbshard1" > ${shard1_file}
mysqldump "${mysql_creds[@]}" "${dump_params[@]}" --where="${test_uids}" passportdbshard1 "${shard_tables[@]}" >> ${shard1_file}

dump_heading "passportdbshard2" > ${shard2_file}
mysqldump "${mysql_creds[@]}" "${dump_params[@]}" --where="${test_uids}" passportdbshard2 "${shard_tables[@]}" >> ${shard2_file}


#dump oauth central and shards

dump_heading "oauthdbcentral" > ${oauthcentral_file}
mysqldump "${mysql_creds[@]}" "${dump_params[@]}" --where="${test_oauth_clients}" oauthdbcentral "${oauth_central_tables[@]}" >> ${oauthcentral_file}

dump_heading "oauthdbshard1" > ${oauthshard_file}
mysqldump "${mysql_creds[@]}" "${dump_params[@]}" --where="${test_oauth_tokens}" oauthdbshard1 "${oauth_shard_tables[@]}" >> ${oauthshard_file}

dump_heading "oauthdbshard2" > ${oauthshard2_file}
mysqldump "${mysql_creds[@]}" "${dump_params[@]}" --where="${test_oauth_tokens}" oauthdbshard2 "${oauth_shard_tables[@]}" >> ${oauthshard2_file}

# use sed to make dumps humah-readable
for dump in "${central_file}" "${shard1_file}" "${shard2_file}" "${oauthcentral_file}" "${oauthshard_file}" "${oauthshard2_file}"; do
    sed -i 's/\(VALUES \|),\)/\1\n  /g' "${dump}"
done
