PY3TEST()

STYLE_PYTHON()

OWNER(g:passport_infra)

TEST_SRCS(test.py)

SIZE(MEDIUM)

DEPENDS(
    passport/infra/tools/ylast
    passport/infra/daemons/sezamapi/daemon
    passport/infra/daemons/sezamapi/ut_last/nginx_mock
)

DATA(
    arcadia/passport/infra/daemons/sezamapi/config
    arcadia/passport/infra/daemons/sezamapi/last-tests
    arcadia/passport/infra/daemons/sezamapi/ut_last/
)

# Fetch from sandbox our minimized geobase binary
# Brings file: test-geodata.bin
# To update this file use passport/infra/daemons/blackbox/ut_last/db/build_geodata.sh
DATA(sbr://770731098)

PEERDIR(
    contrib/python/psutil
    passport/infra/recipes/common
)

# Launch MySQL backend
INCLUDE(${ARCADIA_ROOT}/passport/infra/recipes/mysql/recipe.inc)

USE_RECIPE(
    passport/infra/recipes/mysql/mysql
    passport/infra/daemons/sezamapi/ut_last/db/central.sql
    passport/infra/daemons/sezamapi/ut_last/db/shard1.sql
    passport/infra/daemons/sezamapi/ut_last/db/shard2.sql
    passport/infra/daemons/sezamapi/ut_last/db/oauth_central.sql
    passport/infra/daemons/sezamapi/ut_last/db/oauth_shard.sql
    passport/infra/daemons/sezamapi/ut_last/db/oauth_shard2.sql
)

# Launch passport mock
INCLUDE(${ARCADIA_ROOT}/passport/infra/recipes/passport/recipe.inc)

# Launch TVM
INCLUDE(${ARCADIA_ROOT}/passport/infra/recipes/tvm/recipe.inc)

# Launch BlackBox
INCLUDE(${ARCADIA_ROOT}/passport/infra/recipes/blackbox/recipe.inc)

END()

RECURSE(
    nginx_mock
)
