Общее
================
Общий префикс для проекта - `shg`: shooting gallery.
Цели этого проекта:
1) чтобы у разработчика не было доступа к production данным и секретам
2) чтобы автоматизировать рутину настолько, чтобы не отвлекать кого-то ещё, когда разработчик занимается стрельбами или исследованиями проблем с производительностью

Как пострелять
================

1. Убедиться в том, что есть доступ к стенду

    Массив разрешённых логинов [тут](https://a.yandex-team.ru/arc/trunk/arcadia/passport/infra/daemons/shooting_gallery/shooter/config/config.json): в `allowed_logins`

2. Добыть shg-cli

    Например:
    `sudo apt-get install yandex-passport-shg-cli`

    `--help` тебе в помощь.

3. Убедиться в том, что ssh-agent корректно работает

    Cli подписывает строки через сокет из переменной окружения `SSH_AUTH_SOCK`

4. Захватить на стенд для себя

    В отдельном терминале вызвать команду и оставить так до конца стрельб. Лок висит не более 3 часов.

    `shg-cli mutex lock_and_unlock`

5. Собрать запросы из прода

    Например

    `shg-cli ammo create --hosts=pass-s1.sezam.yandex.net --duration 20`

    Можно указать много хостов через запятую - список поддерживаемых хостов прикопан в конфиге рядом с разрешёнными логинами.

    Чтобы выдать побольше RPS, надо указать побольше хостов. Точной настройки RPS нет.

    Лента живёт не более 10 часов - после этого сама удаляется.

6. Запустить стрельбу

    `shg-cli shooting start --ammo_id kek`

    Лучше всего выбрать какую ленту и стрелять её: так результаты можно будет сравнить между собой.

    Команда выведет в консоль подходящие панельки с графиками.

7. Можно сделать типовой отчёт для Стартрека

    `shg-cli report ...`

Дополнительные возможности:

  * посмотреть текущие версии пакетов

    `shg-cli version get`

  * установить версию для стрельбы

    `shg-cli version install yandex-passport-blackbox=1.2.3`

  * посмотреть `top` на хосте

    `shg-cli state top`

  * собрать `perf top`

    `shg-cli state create_and_get`

  * посмотреть на существующие ленты

    `shg-cli ammo list`

  * есть bash completion

    `source <(shg-cli bash_completion)`

Сущности
================
1) shooter - голова, которая принимает команды от человека и раздаёт их остальным участникам этого праздника
2) prospector - добытчик трафика, слушает его между nginx и blackbox
3) stateviewer - добытчик знаний про perf на стороне мишени и прочее
4) cli - консольный клиент для человека

shooter
----------------
Это "голова". У него есть ручки, предназначенные для остальных участников праздника.
Он принимает команды от cli и начинает их отдавать в ручках для prospector и stateviewer.
Когда команды выполнены, prospector и stateviewer отправляют результаты в shooter.
Отвечает только через https.
Умеет:
1) показывать свой статус
2) управлять патронами
3) управлять стрельбой
4) отдавать top и perf с мишени
5) устанавливать на мишень нужные пакеты
6) показывать текущие версии пакетов на мишени

prospector
----------------
Ходит в shooter через https без аутентификации и через ssh.
Полит из shooter по https знание про то, какие патроны нужно создать.
Создает и отправляет их через scp на машину с shooter.

stateviewer
----------------
Ходит в shooter через https с TVM.
Делает несколько вещей:
1) постоянно пушит top со своей машины (в lz4)
2) постоянно пушит актуальные версии debian-пакетов
3) забирает задание на установку определённых версий пакетов и устанавливает, если надо
4) забирает задание на сбор perf и пушит (в lz4)

cli
----------------
Ходит в shooter через https с ssh-подписью пользователя.
Умеет управлять всеми возможностями shooter.
Из добавленной стоймости:
1) подписывает запросы в ручки
2) умеет в цикле выгружать top на экран
3) умеет блокировать консоль до тех пор, пока пакет не будет установлен
4) разжимает (из lz4) top и perf

Жизненный цикл патронов
================
Shooter не хранит в памяти знание про патроны, которые у него есть - каждый раз ходит на диск, чтобы узнать, какие патроны в наличии.
Исключение - этап создания патронов.

Создание патронов
---------------
1) shooter проверяет, что он ничем другим сейчас не занят
2) shooter генерит новый id (рандом)
3) shooter запоминает id и параметры текущей задачи
4) shooter создаёт каталог на диске: один каталог - одна лента
5) shooter начинает отдавать в ручке для prospector параметры задачи
6) prospector видит задачу, собирает трафик
7) prospector копирует файл (имя файла == имя машины + '.gz') с трафиком на машину shooter'а в каталог с именем из id задачи
8) prospector после окончания копирования отправляет туда файл с суффиксом `.meta` - именно это признак того, что prospector закончил свою задачу
9) shooter ждёт появления последнего `.meta` файла
10) shooter после этого говорит, что лента готова

Удаление патронов
---------------
1) shooter удаляет каталог с указанной лентой

Всё =)
Нет каталога - нет ленты. Таким образом можно удалять хорошие и плохие ленты, а также отменять создание новой ленты.
Prospector не увидит каталога - значит, задачу отменили.

Сетевые доступы
===============
От shooter ( shooting-gallery.sezam.yandex.net ) до:
1) staff-api.yandex-team.ru:443
2) tvm-api.yandex.net:443
3) мишень ( pass-shg-f1.sezam.yandex.net:443,80 )

От prospector ( pass-* - продные истансы ) до:
1) shooter ( shooting-gallery.sezam.yandex.net:22,443 )

От stateviewer ( pass-shg-f1.sezam.yandex.net ) до:
1) shooting-gallery.sezam.yandex.net:443
2) tvm-api.yandex.net:443

От cli ( персональная дырка или на группу ) до:
1) shooting-gallery.sezam.yandex.net:443

Сборка
=============
В [Sandbox](https://sandbox.yandex-team.ru/scheduler/18798)
