package config

import (
	"os"
	"os/user"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/passport/shared/golibs/logger"
)

type Config struct {
	ShooterURL    string
	YasmURL       string
	HomeDir       string
	Username      string
	SSHPrivateKey string
}

func DefaultConfig() *Config {
	u, err := user.Current()
	if err != nil {
		panic(xerrors.Errorf("failed to determine user: %w", err))
	}

	res := &Config{
		ShooterURL: "https://shooting-gallery.sezam.yandex.net",
		YasmURL:    "https://s.yasm.yandex-team.ru",
		HomeDir:    u.HomeDir + "/.shg-cli/",
		Username:   u.Username,
	}

	privateKey := u.HomeDir + "/.ssh/id_rsa"
	if _, err := os.Stat(privateKey); err == nil {
		res.SSHPrivateKey = privateKey
	}

	if _, err := os.Stat(res.HomeDir); os.IsNotExist(err) {
		if err := os.Mkdir(res.HomeDir, os.ModePerm); err != nil {
			logger.Log().Warnf("Failed to create home dir: %s", err)
		}
	}

	return res
}
