package misc

import (
	"fmt"
	"regexp"
	"strconv"
	"strings"
	"time"
)

func Prettify(response []byte) []byte {
	return PrettifyBorn(response)
}

func PrettifyBorn(response []byte) []byte {
	re := regexp.MustCompile(`"born"\s*:\s*(\d+),?`)
	res := re.FindAllSubmatchIndex(response, -1)

	for len(res) > 0 {
		toReplaceWhat := string(response[res[0][0]:res[0][1]])
		t := string(response[res[0][2]:res[0][3]])

		unixtime, _ := strconv.ParseInt(t, 10, 64)
		newValue := time.Unix(unixtime, 0).String()

		toReplaceWith := strings.Replace(toReplaceWhat, t, fmt.Sprintf(`"%s"`, newValue), -1)
		response = []byte(strings.Replace(string(response), toReplaceWhat, toReplaceWith, -1))

		res = re.FindAllSubmatchIndex(response, -1)
	}

	return response
}
