package misc

import (
	"os/exec"

	"a.yandex-team.ru/library/go/core/xerrors"
)

func RunCmd(cmd string) ([]byte, error) {
	out, err := exec.Command("bash", "-c", cmd).CombinedOutput()
	if err != nil {
		err = xerrors.Errorf("failed to run cmd '%s': %w: %s", cmd, err, string(out))
	}
	return out, err
}
