package misc

import (
	"bytes"
	"io/ioutil"

	"github.com/pierrec/lz4"

	"a.yandex-team.ru/library/go/core/xerrors"
)

func Decompress(raw []byte) ([]byte, error) {
	buf := bytes.NewBuffer(raw)
	res, err := ioutil.ReadAll(lz4.NewReader(buf))
	if err != nil {
		return nil, xerrors.Errorf("failed to read from lz4: %w", err)
	}

	return res, nil
}
