package misc

import (
	"encoding/json"

	"github.com/go-resty/resty/v2"

	"a.yandex-team.ru/library/go/core/xerrors"
)

func GetResponse(resp *resty.Response, err error) (int, []byte, error) {
	if err != nil {
		return 0, nil, err
	}

	var val interface{}
	if err := json.Unmarshal(resp.Body(), &val); err != nil {
		return 0, nil, xerrors.Errorf("failed to parse response: %w. \n%s", err, string(resp.Body()))
	}

	out, err := json.MarshalIndent(val, "", "  ")
	if err != nil {
		return 0, nil, xerrors.Errorf("failed to prettify ammo list: %w. \n%s", err, string(resp.Body()))
	}

	return resp.StatusCode(), out, nil
}
