package ammo

import (
	"github.com/spf13/cobra"

	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/config"
)

func Cmd(cfg *config.Config) *cobra.Command {
	res := &cobra.Command{
		Use:   "ammo",
		Short: "Control of ammo life cycle",
		Example: `
shg-cli ammo list
shg-cli ammo delete --ammo_id kek
shg-cli ammo create --hosts=pass-s1.sezam.yandex.net --duration 20
`,
	}
	res.AddCommand(cmdList(cfg))
	res.AddCommand(cmdCreate(cfg))
	res.AddCommand(cmdDelete(cfg))

	return res
}
