package ammo

import (
	"fmt"
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/auth"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/config"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/misc"
)

func cmdDelete(cfg *config.Config) *cobra.Command {
	var id string

	res := &cobra.Command{
		Use:   "delete",
		Short: "Delete ammo or cancel ammo creation",
		RunE: func(cmd *cobra.Command, args []string) error {
			path := fmt.Sprintf(
				"/cli/ammo/delete?id=%s",
				id,
			)

			code, resp, err := misc.GetResponse(auth.CreateRequest(cfg).Post(path))
			if err != nil || code != 200 {
				return xerrors.Errorf("failed to delete ammo: %w. code=%d.\n%s", err, code, string(resp))
			}

			_, _ = os.Stdout.Write(resp)

			return nil
		},
	}

	flags := res.Flags()
	flags.StringVar(&id, "ammo_id", "", "")

	misc.MarkFlagRequired(flags, "ammo_id")

	return res
}
