package mutex

import (
	"fmt"
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/auth"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/config"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/misc"
)

func cmdLock(cfg *config.Config) *cobra.Command {
	var duration uint32

	res := &cobra.Command{
		Use:   "lock",
		Short: "Lock shooter. Nobody else could use shooter",
		Long:  "Lock shooter. Nobody else could use shooter. Lock is always temporary: if you won't specify it, it will be choosen by server",
		RunE: func(cmd *cobra.Command, args []string) error {
			path := fmt.Sprintf("/cli/lock?duration=%d", duration)

			code, resp, err := misc.GetResponse(auth.CreateRequest(cfg).Post(path))
			if err != nil || code != 200 {
				return xerrors.Errorf("failed to lock: %w. code=%d.\n%s", err, code, string(resp))
			}

			_, _ = os.Stdout.Write(resp)

			return nil
		},
	}

	flags := res.Flags()
	flags.Uint32Var(&duration, "duration", 0, "duration of lock. If 0, it will be defined by server")

	return res
}
