package mutex

import (
	"fmt"
	"os"
	"os/signal"
	"syscall"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/auth"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/config"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/misc"
	"a.yandex-team.ru/passport/shared/golibs/logger"
)

func cmdLockAndUnlock(cfg *config.Config) *cobra.Command {
	var duration uint32

	res := &cobra.Command{
		Use:   "lock_and_unlock",
		Short: "Lock shooter and hold it until Ctrl+^C",
		RunE: func(cmd *cobra.Command, args []string) error {
			path := fmt.Sprintf("/cli/lock?duration=%d", duration)

			code, resp, err := misc.GetResponse(auth.CreateRequest(cfg).Post(path))
			if err != nil || code != 200 {
				return xerrors.Errorf("failed to lock: %w. code=%d.\n%s", err, code, string(resp))
			}

			_, _ = os.Stdout.Write(resp)
			_, _ = os.Stdout.Write([]byte("\n"))
			logger.Log().Infof("Waiting for SIGINT (keybord interrupt)...")

			signalChannel := make(chan os.Signal, 1)
			signal.Notify(signalChannel, syscall.SIGINT)
			<-signalChannel

			logger.Log().Infof("Got SIGINT: unlocking...")

			code, resp, err = misc.GetResponse(auth.CreateRequest(cfg).Post("/cli/unlock"))
			if err != nil || code != 200 {
				return xerrors.Errorf("failed to unlock: %w. code=%d.\n%s", err, code, string(resp))
			}
			_, _ = os.Stdout.Write(resp)

			return nil
		},
	}

	flags := res.Flags()
	flags.Uint32Var(&duration, "duration", 0, "duration of lock. If 0, it will be defined by server")

	return res
}
