package mutex

import (
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/auth"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/config"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/misc"
)

func cmdUnlock(cfg *config.Config) *cobra.Command {
	res := &cobra.Command{
		Use:   "unlock",
		Short: "Unlock shooter. Allow somebody to use shooter",
		RunE: func(cmd *cobra.Command, args []string) error {
			code, resp, err := misc.GetResponse(auth.CreateRequest(cfg).Post("/cli/unlock"))
			if err != nil || code != 200 {
				return xerrors.Errorf("failed to unlock: %w. code=%d.\n%s", err, code, string(resp))
			}

			_, _ = os.Stdout.Write(resp)

			return nil
		},
	}

	return res
}
