package report

import (
	"fmt"
	"io/ioutil"
	"os"
	"strings"
	"time"

	"github.com/go-resty/resty/v2"
	"github.com/spf13/cobra"

	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/config"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/misc"
	"a.yandex-team.ru/passport/shared/golibs/logger"
)

const template = `
  <{Панельки в Головане
blackbox:
  * ((https://yasm.yandex-team.ru/menu/passport/blackbox/stable/default/__itype=passportblackbox;__prefix=blackbox;__geo=man;__ctype=production;__tier=shg;__prj=passport.blackbox/?from=__from__&to=__to__ default))
  * ((https://yasm.yandex-team.ru/menu/passport/blackbox/stable/dbpools/__itype=passportblackbox;__prefix=blackbox;__geo=man;__ctype=production;__tier=shg;__prj=passport.blackbox/?from=__from__&to=__to__ dbpool))
  * ((https://yasm.yandex-team.ru/menu/passport/blackbox/stable/specific/__geo=man;__ctype=production;__tier=shg/?from=__from__&to=__to__ specific))
  * ((https://yasm.yandex-team.ru/menu/passport/blackbox/stable/consumers/__geo=man;__ctype=production;__tier=shg/?from=__from__&to=__to__ consumers))
}>

`

func Cmd(cfg *config.Config) *cobra.Command {
	var from int64
	var to int64

	res := &cobra.Command{
		Use:   "report",
		Short: "Create report about shooting for startrek",
		Long:  "Create report about shooting for startrek. Just copy-paste text and upload picture to comment",
		RunE: func(cmd *cobra.Command, args []string) error {
			report := strings.Replace(template, "__from__", fmt.Sprintf("%d", from), -1)
			report = strings.Replace(report, "__to__", fmt.Sprintf("%d", to), -1)
			report = fmt.Sprintf("Стрельба: с %s до %s", time.Unix(from/1000, 0), time.Unix(to/1000, 0)) + report

			_, _ = os.Stdout.Write([]byte(report))

			client := resty.New().
				SetHostURL(cfg.YasmURL).
				SetTimeout(15 * time.Second).
				SetRedirectPolicy(resty.NoRedirectPolicy())

			pngFilename := cfg.HomeDir + "/screen.png"
			path := fmt.Sprintf(
				"/menu/passport/blackbox/stable/default/__itype=passportblackbox;__prefix=blackbox;__geo=man;__ctype=production;__tier=shg;__prj=passport.blackbox/?from=%d&to=%d",
				from,
				to,
			)
			resp, err := client.R().Get(path)
			if err != nil {
				logger.Log().Warnf("failed to get screenshot from yasm: %s", err)
			}
			if resp != nil {
				if resp.StatusCode() != 200 {
					logger.Log().Warnf("failed to get screenshot from. %d: %s", resp.StatusCode(), resp.Body())
				} else {
					if err := ioutil.WriteFile(pngFilename, resp.Body(), os.FileMode(0666)); err != nil {
						logger.Log().Warnf("failed to write screenshot: %s", err)
					} else {
						logger.Log().Infof("Screenshot saved: %s", pngFilename)
					}
				}
			}

			return nil
		},
	}

	flags := res.Flags()
	flags.Int64Var(&from, "from", 0, "from - cgi param from yasm interval")
	flags.Int64Var(&to, "to", 0, "to - cgi param from yasm interval")

	misc.MarkFlagRequired(flags, "from", "to")

	return res
}
