package modes

import (
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/config"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/modes/ammo"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/modes/mutex"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/modes/report"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/modes/shooting"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/modes/state"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/modes/status"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/modes/version"
)

func Execute() {
	cfg := config.DefaultConfig()

	rootCmd := cobra.Command{
		Use:   "shg-cli",
		Short: "This tool is common way to control shooting gallery",
		Example: `
shg-cli status
shg-cli ammo list
shg-cli ammo create --hosts=pass-s1.sezam.yandex.net --duration 20
shg-cli state top
shg-cli state create_and_get
shg-cli version get
shg-cli version install yandex-passport-blackbox=1.2.3
shg-cli shooting start --ammo_id kek
shg-cli mutex lock_and_unlock
`,
	}
	rootCmd.AddCommand(ammo.Cmd(cfg))
	rootCmd.AddCommand(mutex.Cmd(cfg))
	rootCmd.AddCommand(report.Cmd(cfg))
	rootCmd.AddCommand(shooting.Cmd(cfg))
	rootCmd.AddCommand(state.Cmd(cfg))
	rootCmd.AddCommand(status.Cmd(cfg))
	rootCmd.AddCommand(version.Cmd(cfg))

	rootCmd.AddCommand(&cobra.Command{
		Use:   "bash_completion",
		Short: "Generates bash completion scripts",
		Long: `Add to your ~/.bashrc line and restart your bash:
source <(shg-cli bash_completion)
`,
		Run: func(cmd *cobra.Command, args []string) {
			_ = rootCmd.GenBashCompletion(os.Stdout)
		},
	})

	rootCmd.SilenceUsage = true
	if err := rootCmd.Execute(); err != nil {
		os.Exit(1)
	}
	_, _ = os.Stdout.Write([]byte("\n"))
}
