package shooting

import (
	"fmt"
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/auth"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/config"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/misc"
)

const panelLinks = `

=== Yasm panels ===
== blackbox ==
default  : https://nda.ya.ru/t/JkGx1XQy3sSouz
dbpool   : https://nda.ya.ru/t/lPeL-_4A3sSp7X
specific : https://nda.ya.ru/t/aT42Ryxt3sSp8U
consumers: https://nda.ya.ru/t/KIH29Mfh3sSpLN

== shooting gallery ==
CPU    : https://nda.ya.ru/t/XFINKkAa3WvVzd
Network: https://nda.ya.ru/t/zwxL4FYc3WvW5P
`

func cmdStart(cfg *config.Config) *cobra.Command {
	var ammoID string
	var schema string
	var rate uint32
	var instances uint32
	var duration uint32
	var workers uint32
	var connectionClose bool

	res := &cobra.Command{
		Use:   "start",
		Short: "Start shooting: if duration is not specified, it will be choosen by server",
		RunE: func(cmd *cobra.Command, args []string) error {
			path := fmt.Sprintf(
				"/cli/shooting/start?ammo_id=%s&schema=%s&rate=%d&instances=%d&duration=%d&workers=%d",
				ammoID,
				schema,
				rate,
				instances,
				duration,
				workers,
			)
			if connectionClose {
				path = path + "&connection_close=yes"
			}

			code, resp, err := misc.GetResponse(auth.CreateRequest(cfg).Post(path))
			if err != nil || code != 200 {
				return xerrors.Errorf("failed to start shooting: %w. code=%d.\n%s", err, code, string(resp))
			}

			_, _ = os.Stdout.Write(resp)
			_, _ = os.Stdout.Write([]byte(panelLinks))

			return nil
		},
	}

	flags := res.Flags()
	flags.StringVar(&ammoID, "ammo_id", "", "")
	flags.StringVar(&schema, "schema", "https", "")
	flags.Uint32Var(&rate, "rate", 100, "rate of shooting - percentage of ammo")
	flags.Uint32Var(&instances, "instances", 1, "instances of goreplay")
	flags.Uint32Var(&duration, "duration", 0, "")
	flags.Uint32Var(&workers, "workers", 0, "workers per each instance of goreplay")
	flags.BoolVar(&connectionClose, "connection_close", false, "close connection after every request to target (drop keepalive)")

	misc.MarkFlagRequired(flags, "ammo_id")

	return res
}
