package perf

import (
	"fmt"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/auth"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/config"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/misc"
	"a.yandex-team.ru/passport/shared/golibs/logger"
)

func cmdCreateAndGet(cfg *config.Config) *cobra.Command {
	var frequency uint32
	var sleep uint32
	var noFlame bool

	res := &cobra.Command{
		Use:   "create_and_get",
		Short: "Start creating perf, wait for it and fetch",
		Long:  "Start creating perf, wait for it and fetch. Result will be saved in ~/.shg-cli/ with flame graphs",
		RunE: func(cmd *cobra.Command, args []string) error {
			path := fmt.Sprintf(
				"/cli/state/perf?frequency=%d&sleep=%d",
				frequency,
				sleep,
			)

			client := auth.CreateHTTPClient(cfg)
			code, resp, err := misc.GetResponse(auth.CreateRequestWithClient(cfg, client).Post(path))
			if err != nil || code != 200 {
				return xerrors.Errorf("failed to start collecting perf: %w. code=%d.\n%s", err, code, string(resp))
			}

			logger.Log().Infof("Creation command was sent. Waiting for result...")
			for {
				shouldContinue, err := getImpl(cfg, client, noFlame)
				if err != nil || !shouldContinue {
					return err
				}
			}
		},
	}

	flags := res.Flags()
	flags.Uint32Var(&frequency, "frequency", 0, "param for `perf record -F`")
	flags.Uint32Var(&sleep, "sleep", 0, "param for `perf record -- sleep`")
	flags.BoolVar(&noFlame, "no-flamegraph", false, "do not create FlameGraph")

	return res
}
