package state

import (
	"encoding/base64"
	"encoding/json"
	"os"
	"strings"
	"time"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/auth"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/config"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/misc"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/shooter/pkg/stateviewertypes"
)

func cmdTop(cfg *config.Config) *cobra.Command {
	var lines uint32
	var period uint32

	res := &cobra.Command{
		Use:   "top",
		Short: "Get top from target host in read-only mode. Works infinite",
		RunE: func(cmd *cobra.Command, args []string) error {
			client := auth.CreateHTTPClient(cfg)

			for {
				code, resp, err := misc.GetResponse(
					auth.CreateRequestWithClient(cfg, client).
						Get("/cli/state/top"))
				if err != nil || code != 200 {
					return xerrors.Errorf("failed to get top: %w. code=%d.\n%s", err, code, string(resp))
				}

				var top stateviewertypes.Top
				_ = json.Unmarshal(resp, &top)

				data, err := base64.RawURLEncoding.DecodeString(top.Output)
				if err != nil {
					return xerrors.Errorf("failed to decode base64url with top: %s: %w", top.Output, err)
				}
				data, err = misc.Decompress(data)
				if err != nil {
					return xerrors.Errorf("failed to decompress top: %s: %w", top.Output, err)
				}

				str := string(data)
				idx := strings.LastIndex(str, "top - ")
				if idx == -1 {
					return xerrors.Errorf("failed to find begining of top.\n%s", str)
				}
				str = str[idx:]

				_, _ = os.Stdout.Write([]byte(strings.Join(strings.Split(str, "\n")[:lines], "\n") + "\n\n"))

				time.Sleep(time.Duration(period) * time.Second)
			}
		},
	}

	flags := res.Flags()
	flags.Uint32Var(&lines, "lines", 30, "lines of top")
	flags.Uint32Var(&period, "period", 2, "period of refresh in seconds")

	return res
}
