package status

import (
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/auth"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/config"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/misc"
)

func Cmd(cfg *config.Config) *cobra.Command {
	res := &cobra.Command{
		Use:   "status",
		Short: "Show status of shooter",
		RunE: func(cmd *cobra.Command, args []string) error {
			code, resp, err := misc.GetResponse(auth.CreateRequest(cfg).Get("/cli/status"))
			if err != nil || code != 200 {
				return xerrors.Errorf("failed to get status: %w. code=%d.\n%s", err, code, string(resp))
			}

			_, _ = os.Stdout.Write(misc.Prettify(resp))

			return nil
		},
	}

	return res
}
