package version

import (
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/auth"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/config"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/cli/internal/misc"
)

func cmdGet(cfg *config.Config) *cobra.Command {
	res := &cobra.Command{
		Use:   "get",
		Short: "Get versions of controlled debian packages",
		RunE: func(cmd *cobra.Command, args []string) error {
			code, resp, err := misc.GetResponse(auth.CreateRequest(cfg).Get("/cli/version"))
			if err != nil || code != 200 {
				return xerrors.Errorf("failed to get version: %w. code=%d.\n%s", err, code, string(resp))
			}

			_, _ = os.Stdout.Write(resp)

			return nil
		},
	}

	return res
}
