package main

import (
	"flag"
	"fmt"
	"os"

	"a.yandex-team.ru/library/go/maxprocs"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/prospector/internal/srv"
)

func main() {
	maxprocs.AdjustAuto()

	cfgFile := flag.String("c", "", "config file")
	flag.Parse()

	if len(*cfgFile) == 0 {
		_, _ = fmt.Fprintln(os.Stderr, "config is required")
		flag.Usage()
		os.Exit(1)
	}

	if err := srv.Run(*cfgFile); err != nil {
		_, _ = fmt.Fprintf(os.Stderr, "Error: %s\n", err)
		os.Exit(1)
	}
}
