package prospector

import (
	"os/exec"
	"strings"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/passport/shared/golibs/logger"
)

type CmdRunner interface {
	Run(cmd string) ([]byte, error)
}

type cmdRunner struct {
}

func (c *cmdRunner) Run(cmd string) ([]byte, error) {
	logger.Log().Debugf("Trying to run cmd: '%s'", cmd)

	parts := strings.Fields(cmd)
	head := parts[0]
	parts = parts[1:]

	out, err := exec.Command(head, parts...).CombinedOutput()
	if err != nil {
		err = xerrors.Errorf("failed to run cmd '%s': %w: %s", cmd, err, string(out))
		logger.Log().Errorf("Failed to run cmd: '%s'", cmd)
	} else {
		logger.Log().Infof("Succeed to run cmd: '%s'", cmd)
	}
	return out, err
}
