package prospector

import (
	"context"

	"github.com/go-resty/resty/v2"

	"a.yandex-team.ru/library/go/core/xerrors"
)

type HTTPGetter interface {
	Get(path string) (int, []byte, error)
}

type httpGetter struct {
	client *resty.Client
}

func (tg *httpGetter) Get(path string) (int, []byte, error) {
	resp, err := tg.client.R().
		SetContext(context.Background()).
		Get(path)

	if err != nil {
		return 0, nil, xerrors.Errorf("failed to get task from shooter: %w", err)
	}

	return resp.StatusCode(), resp.Body(), nil
}
