package ammo

import (
	"os"

	"a.yandex-team.ru/library/go/core/xerrors"
)

type DeleteResult map[string]string

func (s *State) Delete(id string) (DeleteResult, error, error) {
	s.mutex.Lock()
	defer s.mutex.Unlock()

	path := s.getPackPath(id)
	_, err := os.Stat(path)
	if os.IsNotExist(err) {
		return nil, xerrors.Errorf("ammo is absent: %s", id), nil
	}

	err = os.RemoveAll(path)
	if err != nil {
		return nil, nil, err
	}

	res := DeleteResult{
		"status": "ok",
	}

	if s.task != nil && s.task.id == id {
		s.task.shouldStop = true
		res["extra_info"] = "task will stop soon"
	}

	return res, nil, nil
}
